function LPIVci = doLPIVci(LPIV,clevel,method)

% Inference:
% method  1: Stata ivreg2 
% method  2: Anderson-Rubin
% method  3: Mertens Montiel-Olea

% Dimension of VARci.irsH and VARci.irsL: 
% 1: horizon 2: # of variables 3: clevel 4: shock (if more than one shock with instrument)

scale              = -1;

LPIVci.fstage_ivreg2 = ((LPIV.gamma1(1)).^2)./(LPIV.OmegaSTATA(2,2,1,1)/LPIV.T);
LPIVci.fstage_MMO    = doFstageMSW(LPIV);

% gamma1 = ZMZp\(Z'*M*Y./LPIV.T);
% fstage = ((gamma1).^2)./(Omega/LPIV.T);

for h = 0:LPIV.irhor-1
    OmegaSTATAaux  = squeeze(LPIV.OmegaSTATA(1,1,:,1+h))*((LPIV.T-h-LPIV.k)/(LPIV.T-h));
    serrs (1+h,:) = ((OmegaSTATAaux./((LPIV.gamma1(1+h,:).^2)*(LPIV.T-h))).^.5);
end

LPIVci.irsL = NaN*zeros([size(LPIV.irs) length(clevel)]);
LPIVci.irsH = NaN*zeros([size(LPIV.irs) length(clevel)]);

  
if method == 1 % Standard CI       
    for jj = 1:length(clevel)
    LPIVci.irsL(:,:,jj)   = LPIV.irs-abs(scale)*(norminv(1-((1-clevel(jj)/100)/2)))*serrs;
    LPIVci.irsH(:,:,jj)   = LPIV.irs+abs(scale)*(norminv(1-((1-clevel(jj)/100)/2)))*serrs;
    end
elseif (method == 2)||(method == 3)  % Weak IV robust CI: 2) Anderson-Rubin 3) Mertens-Montiel-Olea
    ngrid   = 1000; % Number of Grid points
            
    grid_LB = LPIV.irs./scale-5*serrs;
    grid_UB = LPIV.irs./scale+5*serrs;
        
    ARSTAT = zeros(ngrid,LPIV.irhor, LPIV.n);
    ARcval = zeros(ngrid,LPIV.irhor, LPIV.n);
    for n = 1:LPIV.n
        GRID    = repmat(grid_LB(:,n),[1 ngrid])+repmat(1:ngrid,[LPIV.irhor 1]).*repmat((grid_UB(:,n)-grid_LB(:,n))/ngrid,[1,ngrid]);
        % Get Statistic
        if method == 2
            [ARSTAT(:,:,n),Om] = do_LPIV_ARtest(LPIV,GRID,n);          
        elseif method==3
            VAR = LPIV;
            VAR = doProxySVAR(VAR);
            AL          = VAR.bet(1:end-size(VAR.DET,2),:)';
            Gamma       = VAR.res'*VAR.m./VAR.T; 
            Caux        = [eye(VAR.n),MARep(AL,VAR.p,VAR.irhor-1)]; 
            C           = reshape(Caux,[VAR.n,VAR.n,VAR.irhor]); 
            [ARSTAT(:,:,n),Om] = do_LPIV_ARtest_MMO(LPIV,GRID,n,VAR.res,C);            
        end
        % Get Critical Values
        for h = 0:LPIV.irhor-1
            for jj =  1:length(clevel)
                for nn = 1:ngrid
                   if method == 2 
                   ARcval(nn,1+h,n,jj)      = chi2inv(1-((1-clevel(jj)/100)),1)*...
                     [1; -GRID(1+h,nn)]'*Om(:,:,1+h)*[1; -GRID(1+h,nn)];                
                   elseif method ==3
                   ARcval(nn,1+h,n,jj)= chi2inv(1-((1-clevel(jj)/100)),1)*Om(:,:,1+h,nn);
                   end
                end               
            end        
        end     
    end
    ARSTATA=repmat(ARSTAT,[1 1 1 length(clevel)])>ARcval;
    for n = 1:LPIV.n
        GRID    = repmat(grid_LB(:,n),[1 ngrid])+repmat(1:ngrid,[LPIV.irhor 1]).*repmat((grid_UB(:,n)-grid_LB(:,n))/ngrid,[1,ngrid]);
        for h = 0:LPIV.irhor-1
            for jj =  1:length(clevel)
                aux = find(ARSTATA(:,1+h,n,jj)==0);
                if isempty(aux)==0
                LPIVci.irsH(1+h,n,jj) = scale*GRID(1+h,aux(1));  
                LPIVci.irsL(1+h,n,jj) = scale*GRID(1+h,aux(end));  
                end                  
            end        
        end     
    end
 LPIVci.irsH(1,1,:) = scale;  
 LPIVci.irsL(1,1,:) = scale;
elseif method == 3
    
end
        
